﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/pricing/model/ListPriceListsResult.h>

#include <utility>

using namespace Aws::Pricing::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListPriceListsResult::ListPriceListsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListPriceListsResult& ListPriceListsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("PriceLists")) {
    Aws::Utils::Array<JsonView> priceListsJsonList = jsonValue.GetArray("PriceLists");
    for (unsigned priceListsIndex = 0; priceListsIndex < priceListsJsonList.GetLength(); ++priceListsIndex) {
      m_priceLists.push_back(priceListsJsonList[priceListsIndex].AsObject());
    }
    m_priceListsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
