﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/rds/model/ModifyCurrentDBClusterCapacityRequest.h>

using namespace Aws::RDS::Model;
using namespace Aws::Utils;

Aws::String ModifyCurrentDBClusterCapacityRequest::SerializePayload() const {
  Aws::StringStream ss;
  ss << "Action=ModifyCurrentDBClusterCapacity&";
  if (m_dBClusterIdentifierHasBeenSet) {
    ss << "DBClusterIdentifier=" << StringUtils::URLEncode(m_dBClusterIdentifier.c_str()) << "&";
  }

  if (m_capacityHasBeenSet) {
    ss << "Capacity=" << m_capacity << "&";
  }

  if (m_secondsBeforeTimeoutHasBeenSet) {
    ss << "SecondsBeforeTimeout=" << m_secondsBeforeTimeout << "&";
  }

  if (m_timeoutActionHasBeenSet) {
    ss << "TimeoutAction=" << StringUtils::URLEncode(m_timeoutAction.c_str()) << "&";
  }

  ss << "Version=2014-10-31";
  return ss.str();
}

void ModifyCurrentDBClusterCapacityRequest::DumpBodyToUrl(Aws::Http::URI& uri) const { uri.SetQueryString(SerializePayload()); }
