﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/resiliencehub/model/DescribeAppVersionResourceRequest.h>

#include <utility>

using namespace Aws::ResilienceHub::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DescribeAppVersionResourceRequest::SerializePayload() const {
  JsonValue payload;

  if (m_appArnHasBeenSet) {
    payload.WithString("appArn", m_appArn);
  }

  if (m_appVersionHasBeenSet) {
    payload.WithString("appVersion", m_appVersion);
  }

  if (m_awsAccountIdHasBeenSet) {
    payload.WithString("awsAccountId", m_awsAccountId);
  }

  if (m_awsRegionHasBeenSet) {
    payload.WithString("awsRegion", m_awsRegion);
  }

  if (m_logicalResourceIdHasBeenSet) {
    payload.WithObject("logicalResourceId", m_logicalResourceId.Jsonize());
  }

  if (m_physicalResourceIdHasBeenSet) {
    payload.WithString("physicalResourceId", m_physicalResourceId);
  }

  if (m_resourceNameHasBeenSet) {
    payload.WithString("resourceName", m_resourceName);
  }

  return payload.View().WriteReadable();
}
