﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/resourcegroupstaggingapi/model/TagResourcesResult.h>

#include <utility>

using namespace Aws::ResourceGroupsTaggingAPI::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

TagResourcesResult::TagResourcesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

TagResourcesResult& TagResourcesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("FailedResourcesMap")) {
    Aws::Map<Aws::String, JsonView> failedResourcesMapJsonMap = jsonValue.GetObject("FailedResourcesMap").GetAllObjects();
    for (auto& failedResourcesMapItem : failedResourcesMapJsonMap) {
      m_failedResourcesMap[failedResourcesMapItem.first] = failedResourcesMapItem.second.AsObject();
    }
    m_failedResourcesMapHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
