﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/service-quotas/model/ListRequestedServiceQuotaChangeHistoryByQuotaResult.h>

#include <utility>

using namespace Aws::ServiceQuotas::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListRequestedServiceQuotaChangeHistoryByQuotaResult::ListRequestedServiceQuotaChangeHistoryByQuotaResult(
    const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

ListRequestedServiceQuotaChangeHistoryByQuotaResult& ListRequestedServiceQuotaChangeHistoryByQuotaResult::operator=(
    const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }
  if (jsonValue.ValueExists("RequestedQuotas")) {
    Aws::Utils::Array<JsonView> requestedQuotasJsonList = jsonValue.GetArray("RequestedQuotas");
    for (unsigned requestedQuotasIndex = 0; requestedQuotasIndex < requestedQuotasJsonList.GetLength(); ++requestedQuotasIndex) {
      m_requestedQuotas.push_back(requestedQuotasJsonList[requestedQuotasIndex].AsObject());
    }
    m_requestedQuotasHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
