﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/service-quotas/model/PeriodUnit.h>

using namespace Aws::Utils;

namespace Aws {
namespace ServiceQuotas {
namespace Model {
namespace PeriodUnitMapper {

static const int MICROSECOND_HASH = HashingUtils::HashString("MICROSECOND");
static const int MILLISECOND_HASH = HashingUtils::HashString("MILLISECOND");
static const int SECOND_HASH = HashingUtils::HashString("SECOND");
static const int MINUTE_HASH = HashingUtils::HashString("MINUTE");
static const int HOUR_HASH = HashingUtils::HashString("HOUR");
static const int DAY_HASH = HashingUtils::HashString("DAY");
static const int WEEK_HASH = HashingUtils::HashString("WEEK");

PeriodUnit GetPeriodUnitForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == MICROSECOND_HASH) {
    return PeriodUnit::MICROSECOND;
  } else if (hashCode == MILLISECOND_HASH) {
    return PeriodUnit::MILLISECOND;
  } else if (hashCode == SECOND_HASH) {
    return PeriodUnit::SECOND;
  } else if (hashCode == MINUTE_HASH) {
    return PeriodUnit::MINUTE;
  } else if (hashCode == HOUR_HASH) {
    return PeriodUnit::HOUR;
  } else if (hashCode == DAY_HASH) {
    return PeriodUnit::DAY;
  } else if (hashCode == WEEK_HASH) {
    return PeriodUnit::WEEK;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<PeriodUnit>(hashCode);
  }

  return PeriodUnit::NOT_SET;
}

Aws::String GetNameForPeriodUnit(PeriodUnit enumValue) {
  switch (enumValue) {
    case PeriodUnit::NOT_SET:
      return {};
    case PeriodUnit::MICROSECOND:
      return "MICROSECOND";
    case PeriodUnit::MILLISECOND:
      return "MILLISECOND";
    case PeriodUnit::SECOND:
      return "SECOND";
    case PeriodUnit::MINUTE:
      return "MINUTE";
    case PeriodUnit::HOUR:
      return "HOUR";
    case PeriodUnit::DAY:
      return "DAY";
    case PeriodUnit::WEEK:
      return "WEEK";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace PeriodUnitMapper
}  // namespace Model
}  // namespace ServiceQuotas
}  // namespace Aws
