﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/support/model/AddAttachmentsToSetResult.h>

#include <utility>

using namespace Aws::Support::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

AddAttachmentsToSetResult::AddAttachmentsToSetResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

AddAttachmentsToSetResult& AddAttachmentsToSetResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("attachmentSetId")) {
    m_attachmentSetId = jsonValue.GetString("attachmentSetId");
    m_attachmentSetIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("expiryTime")) {
    m_expiryTime = jsonValue.GetString("expiryTime");
    m_expiryTimeHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
