﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/textract/model/AnalyzeIDDetections.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Textract {
namespace Model {

AnalyzeIDDetections::AnalyzeIDDetections(JsonView jsonValue) { *this = jsonValue; }

AnalyzeIDDetections& AnalyzeIDDetections::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Text")) {
    m_text = jsonValue.GetString("Text");
    m_textHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NormalizedValue")) {
    m_normalizedValue = jsonValue.GetObject("NormalizedValue");
    m_normalizedValueHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Confidence")) {
    m_confidence = jsonValue.GetDouble("Confidence");
    m_confidenceHasBeenSet = true;
  }
  return *this;
}

JsonValue AnalyzeIDDetections::Jsonize() const {
  JsonValue payload;

  if (m_textHasBeenSet) {
    payload.WithString("Text", m_text);
  }

  if (m_normalizedValueHasBeenSet) {
    payload.WithObject("NormalizedValue", m_normalizedValue.Jsonize());
  }

  if (m_confidenceHasBeenSet) {
    payload.WithDouble("Confidence", m_confidence);
  }

  return payload;
}

}  // namespace Model
}  // namespace Textract
}  // namespace Aws
