﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/textract/model/DetectDocumentTextRequest.h>

#include <utility>

using namespace Aws::Textract::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DetectDocumentTextRequest::SerializePayload() const {
  JsonValue payload;

  if (m_documentHasBeenSet) {
    payload.WithObject("Document", m_document.Jsonize());
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DetectDocumentTextRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "Textract.DetectDocumentText"));
  return headers;
}
