﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/HashingUtils.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/textract/model/Document.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Textract {
namespace Model {

Document::Document(JsonView jsonValue) { *this = jsonValue; }

Document& Document::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Bytes")) {
    m_bytes = HashingUtils::Base64Decode(jsonValue.GetString("Bytes"));
    m_bytesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("S3Object")) {
    m_s3Object = jsonValue.GetObject("S3Object");
    m_s3ObjectHasBeenSet = true;
  }
  return *this;
}

JsonValue Document::Jsonize() const {
  JsonValue payload;

  if (m_bytesHasBeenSet) {
    payload.WithString("Bytes", HashingUtils::Base64Encode(m_bytes));
  }

  if (m_s3ObjectHasBeenSet) {
    payload.WithObject("S3Object", m_s3Object.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace Textract
}  // namespace Aws
