﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/textract/model/ExpenseGroupProperty.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Textract {
namespace Model {

ExpenseGroupProperty::ExpenseGroupProperty(JsonView jsonValue) { *this = jsonValue; }

ExpenseGroupProperty& ExpenseGroupProperty::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Types")) {
    Aws::Utils::Array<JsonView> typesJsonList = jsonValue.GetArray("Types");
    for (unsigned typesIndex = 0; typesIndex < typesJsonList.GetLength(); ++typesIndex) {
      m_types.push_back(typesJsonList[typesIndex].AsString());
    }
    m_typesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Id")) {
    m_id = jsonValue.GetString("Id");
    m_idHasBeenSet = true;
  }
  return *this;
}

JsonValue ExpenseGroupProperty::Jsonize() const {
  JsonValue payload;

  if (m_typesHasBeenSet) {
    Aws::Utils::Array<JsonValue> typesJsonList(m_types.size());
    for (unsigned typesIndex = 0; typesIndex < typesJsonList.GetLength(); ++typesIndex) {
      typesJsonList[typesIndex].AsString(m_types[typesIndex]);
    }
    payload.WithArray("Types", std::move(typesJsonList));
  }

  if (m_idHasBeenSet) {
    payload.WithString("Id", m_id);
  }

  return payload;
}

}  // namespace Model
}  // namespace Textract
}  // namespace Aws
