﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/textract/model/ListAdapterVersionsResult.h>

#include <utility>

using namespace Aws::Textract::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListAdapterVersionsResult::ListAdapterVersionsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListAdapterVersionsResult& ListAdapterVersionsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("AdapterVersions")) {
    Aws::Utils::Array<JsonView> adapterVersionsJsonList = jsonValue.GetArray("AdapterVersions");
    for (unsigned adapterVersionsIndex = 0; adapterVersionsIndex < adapterVersionsJsonList.GetLength(); ++adapterVersionsIndex) {
      m_adapterVersions.push_back(adapterVersionsJsonList[adapterVersionsIndex].AsObject());
    }
    m_adapterVersionsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
