﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/tnb/model/GetSolFunctionPackageContentResult.h>

#include <utility>

using namespace Aws::tnb::Model;
using namespace Aws::Utils::Stream;
using namespace Aws::Utils;
using namespace Aws;

GetSolFunctionPackageContentResult::GetSolFunctionPackageContentResult(Aws::AmazonWebServiceResult<ResponseStream>&& result) {
  *this = std::move(result);
}

GetSolFunctionPackageContentResult& GetSolFunctionPackageContentResult::operator=(Aws::AmazonWebServiceResult<ResponseStream>&& result) {
  m_packageContent = result.TakeOwnershipOfPayload();
  m_packageContentHasBeenSet = true;

  const auto& headers = result.GetHeaderValueCollection();
  const auto& contentTypeIter = headers.find("content-type");
  if (contentTypeIter != headers.end()) {
    m_contentType = PackageContentTypeMapper::GetPackageContentTypeForName(contentTypeIter->second);
    m_contentTypeHasBeenSet = true;
  }

  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
