﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/tnb/model/ListSolNetworkInstancesResult.h>

#include <utility>

using namespace Aws::tnb::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListSolNetworkInstancesResult::ListSolNetworkInstancesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListSolNetworkInstancesResult& ListSolNetworkInstancesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("networkInstances")) {
    Aws::Utils::Array<JsonView> networkInstancesJsonList = jsonValue.GetArray("networkInstances");
    for (unsigned networkInstancesIndex = 0; networkInstancesIndex < networkInstancesJsonList.GetLength(); ++networkInstancesIndex) {
      m_networkInstances.push_back(networkInstancesJsonList[networkInstancesIndex].AsObject());
    }
    m_networkInstancesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
