﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/tnb/model/ListSolNetworkOperationsResult.h>

#include <utility>

using namespace Aws::tnb::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListSolNetworkOperationsResult::ListSolNetworkOperationsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListSolNetworkOperationsResult& ListSolNetworkOperationsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("networkOperations")) {
    Aws::Utils::Array<JsonView> networkOperationsJsonList = jsonValue.GetArray("networkOperations");
    for (unsigned networkOperationsIndex = 0; networkOperationsIndex < networkOperationsJsonList.GetLength(); ++networkOperationsIndex) {
      m_networkOperations.push_back(networkOperationsJsonList[networkOperationsIndex].AsObject());
    }
    m_networkOperationsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
