﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/tnb/model/ListSolNetworkPackagesResult.h>

#include <utility>

using namespace Aws::tnb::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListSolNetworkPackagesResult::ListSolNetworkPackagesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListSolNetworkPackagesResult& ListSolNetworkPackagesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("networkPackages")) {
    Aws::Utils::Array<JsonView> networkPackagesJsonList = jsonValue.GetArray("networkPackages");
    for (unsigned networkPackagesIndex = 0; networkPackagesIndex < networkPackagesJsonList.GetLength(); ++networkPackagesIndex) {
      m_networkPackages.push_back(networkPackagesJsonList[networkPackagesIndex].AsObject());
    }
    m_networkPackagesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
