﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/tnb/model/NsdOperationalState.h>

using namespace Aws::Utils;

namespace Aws {
namespace tnb {
namespace Model {
namespace NsdOperationalStateMapper {

static const int ENABLED_HASH = HashingUtils::HashString("ENABLED");
static const int DISABLED_HASH = HashingUtils::HashString("DISABLED");

NsdOperationalState GetNsdOperationalStateForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == ENABLED_HASH) {
    return NsdOperationalState::ENABLED;
  } else if (hashCode == DISABLED_HASH) {
    return NsdOperationalState::DISABLED;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<NsdOperationalState>(hashCode);
  }

  return NsdOperationalState::NOT_SET;
}

Aws::String GetNameForNsdOperationalState(NsdOperationalState enumValue) {
  switch (enumValue) {
    case NsdOperationalState::NOT_SET:
      return {};
    case NsdOperationalState::ENABLED:
      return "ENABLED";
    case NsdOperationalState::DISABLED:
      return "DISABLED";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace NsdOperationalStateMapper
}  // namespace Model
}  // namespace tnb
}  // namespace Aws
