﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/tnb/model/OperationalState.h>

using namespace Aws::Utils;

namespace Aws {
namespace tnb {
namespace Model {
namespace OperationalStateMapper {

static const int ENABLED_HASH = HashingUtils::HashString("ENABLED");
static const int DISABLED_HASH = HashingUtils::HashString("DISABLED");

OperationalState GetOperationalStateForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == ENABLED_HASH) {
    return OperationalState::ENABLED;
  } else if (hashCode == DISABLED_HASH) {
    return OperationalState::DISABLED;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<OperationalState>(hashCode);
  }

  return OperationalState::NOT_SET;
}

Aws::String GetNameForOperationalState(OperationalState enumValue) {
  switch (enumValue) {
    case OperationalState::NOT_SET:
      return {};
    case OperationalState::ENABLED:
      return "ENABLED";
    case OperationalState::DISABLED:
      return "DISABLED";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace OperationalStateMapper
}  // namespace Model
}  // namespace tnb
}  // namespace Aws
