﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/verifiedpermissions/model/ListPolicyStoresResult.h>

#include <utility>

using namespace Aws::VerifiedPermissions::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListPolicyStoresResult::ListPolicyStoresResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListPolicyStoresResult& ListPolicyStoresResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }
  if (jsonValue.ValueExists("policyStores")) {
    Aws::Utils::Array<JsonView> policyStoresJsonList = jsonValue.GetArray("policyStores");
    for (unsigned policyStoresIndex = 0; policyStoresIndex < policyStoresJsonList.GetLength(); ++policyStoresIndex) {
      m_policyStores.push_back(policyStoresJsonList[policyStoresIndex].AsObject());
    }
    m_policyStoresHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
