﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/wisdom/model/CreateQuickResponseRequest.h>

#include <utility>

using namespace Aws::ConnectWisdomService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateQuickResponseRequest::SerializePayload() const {
  JsonValue payload;

  if (m_channelsHasBeenSet) {
    Aws::Utils::Array<JsonValue> channelsJsonList(m_channels.size());
    for (unsigned channelsIndex = 0; channelsIndex < channelsJsonList.GetLength(); ++channelsIndex) {
      channelsJsonList[channelsIndex].AsString(m_channels[channelsIndex]);
    }
    payload.WithArray("channels", std::move(channelsJsonList));
  }

  if (m_clientTokenHasBeenSet) {
    payload.WithString("clientToken", m_clientToken);
  }

  if (m_contentHasBeenSet) {
    payload.WithObject("content", m_content.Jsonize());
  }

  if (m_contentTypeHasBeenSet) {
    payload.WithString("contentType", m_contentType);
  }

  if (m_descriptionHasBeenSet) {
    payload.WithString("description", m_description);
  }

  if (m_groupingConfigurationHasBeenSet) {
    payload.WithObject("groupingConfiguration", m_groupingConfiguration.Jsonize());
  }

  if (m_isActiveHasBeenSet) {
    payload.WithBool("isActive", m_isActive);
  }

  if (m_languageHasBeenSet) {
    payload.WithString("language", m_language);
  }

  if (m_nameHasBeenSet) {
    payload.WithString("name", m_name);
  }

  if (m_shortcutKeyHasBeenSet) {
    payload.WithString("shortcutKey", m_shortcutKey);
  }

  if (m_tagsHasBeenSet) {
    JsonValue tagsJsonMap;
    for (auto& tagsItem : m_tags) {
      tagsJsonMap.WithString(tagsItem.first, tagsItem.second);
    }
    payload.WithObject("tags", std::move(tagsJsonMap));
  }

  return payload.View().WriteReadable();
}
