﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/wisdom/model/FilterField.h>

using namespace Aws::Utils;

namespace Aws {
namespace ConnectWisdomService {
namespace Model {
namespace FilterFieldMapper {

static const int NAME_HASH = HashingUtils::HashString("NAME");

FilterField GetFilterFieldForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == NAME_HASH) {
    return FilterField::NAME;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<FilterField>(hashCode);
  }

  return FilterField::NOT_SET;
}

Aws::String GetNameForFilterField(FilterField enumValue) {
  switch (enumValue) {
    case FilterField::NOT_SET:
      return {};
    case FilterField::NAME:
      return "NAME";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace FilterFieldMapper
}  // namespace Model
}  // namespace ConnectWisdomService
}  // namespace Aws
