﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/wisdom/model/StartContentUploadRequest.h>

#include <utility>

using namespace Aws::ConnectWisdomService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String StartContentUploadRequest::SerializePayload() const {
  JsonValue payload;

  if (m_contentTypeHasBeenSet) {
    payload.WithString("contentType", m_contentType);
  }

  if (m_presignedUrlTimeToLiveHasBeenSet) {
    payload.WithInteger("presignedUrlTimeToLive", m_presignedUrlTimeToLive);
  }

  return payload.View().WriteReadable();
}
