﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/workspaces-instances/model/LicenseConfigurationRequest.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace WorkspacesInstances {
namespace Model {

LicenseConfigurationRequest::LicenseConfigurationRequest(JsonView jsonValue) { *this = jsonValue; }

LicenseConfigurationRequest& LicenseConfigurationRequest::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("LicenseConfigurationArn")) {
    m_licenseConfigurationArn = jsonValue.GetString("LicenseConfigurationArn");
    m_licenseConfigurationArnHasBeenSet = true;
  }
  return *this;
}

JsonValue LicenseConfigurationRequest::Jsonize() const {
  JsonValue payload;

  if (m_licenseConfigurationArnHasBeenSet) {
    payload.WithString("LicenseConfigurationArn", m_licenseConfigurationArn);
  }

  return payload;
}

}  // namespace Model
}  // namespace WorkspacesInstances
}  // namespace Aws
