﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/workspaces-instances/model/ListWorkspaceInstancesResult.h>

#include <utility>

using namespace Aws::WorkspacesInstances::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListWorkspaceInstancesResult::ListWorkspaceInstancesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListWorkspaceInstancesResult& ListWorkspaceInstancesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("WorkspaceInstances")) {
    Aws::Utils::Array<JsonView> workspaceInstancesJsonList = jsonValue.GetArray("WorkspaceInstances");
    for (unsigned workspaceInstancesIndex = 0; workspaceInstancesIndex < workspaceInstancesJsonList.GetLength();
         ++workspaceInstancesIndex) {
      m_workspaceInstances.push_back(workspaceInstancesJsonList[workspaceInstancesIndex].AsObject());
    }
    m_workspaceInstancesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
