﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/http/URI.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/finspace/model/DeleteKxScalingGroupRequest.h>

#include <utility>

using namespace Aws::finspace::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

Aws::String DeleteKxScalingGroupRequest::SerializePayload() const { return {}; }

void DeleteKxScalingGroupRequest::AddQueryStringParameters(URI& uri) const {
  Aws::StringStream ss;
  if (m_clientTokenHasBeenSet) {
    ss << m_clientToken;
    uri.AddQueryStringParameter("clientToken", ss.str());
    ss.str("");
  }
}
