﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/logs/model/OpenSearchDataSource.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace CloudWatchLogs {
namespace Model {

OpenSearchDataSource::OpenSearchDataSource(JsonView jsonValue) { *this = jsonValue; }

OpenSearchDataSource& OpenSearchDataSource::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("dataSourceName")) {
    m_dataSourceName = jsonValue.GetString("dataSourceName");
    m_dataSourceNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("status")) {
    m_status = jsonValue.GetObject("status");
    m_statusHasBeenSet = true;
  }
  return *this;
}

JsonValue OpenSearchDataSource::Jsonize() const {
  JsonValue payload;

  if (m_dataSourceNameHasBeenSet) {
    payload.WithString("dataSourceName", m_dataSourceName);
  }

  if (m_statusHasBeenSet) {
    payload.WithObject("status", m_status.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace CloudWatchLogs
}  // namespace Aws
