﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/logs/model/SubscriptionFilter.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace CloudWatchLogs {
namespace Model {

SubscriptionFilter::SubscriptionFilter(JsonView jsonValue) { *this = jsonValue; }

SubscriptionFilter& SubscriptionFilter::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("filterName")) {
    m_filterName = jsonValue.GetString("filterName");
    m_filterNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("logGroupName")) {
    m_logGroupName = jsonValue.GetString("logGroupName");
    m_logGroupNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("filterPattern")) {
    m_filterPattern = jsonValue.GetString("filterPattern");
    m_filterPatternHasBeenSet = true;
  }
  if (jsonValue.ValueExists("destinationArn")) {
    m_destinationArn = jsonValue.GetString("destinationArn");
    m_destinationArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("roleArn")) {
    m_roleArn = jsonValue.GetString("roleArn");
    m_roleArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("distribution")) {
    m_distribution = DistributionMapper::GetDistributionForName(jsonValue.GetString("distribution"));
    m_distributionHasBeenSet = true;
  }
  if (jsonValue.ValueExists("applyOnTransformedLogs")) {
    m_applyOnTransformedLogs = jsonValue.GetBool("applyOnTransformedLogs");
    m_applyOnTransformedLogsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("creationTime")) {
    m_creationTime = jsonValue.GetInt64("creationTime");
    m_creationTimeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("fieldSelectionCriteria")) {
    m_fieldSelectionCriteria = jsonValue.GetString("fieldSelectionCriteria");
    m_fieldSelectionCriteriaHasBeenSet = true;
  }
  if (jsonValue.ValueExists("emitSystemFields")) {
    Aws::Utils::Array<JsonView> emitSystemFieldsJsonList = jsonValue.GetArray("emitSystemFields");
    for (unsigned emitSystemFieldsIndex = 0; emitSystemFieldsIndex < emitSystemFieldsJsonList.GetLength(); ++emitSystemFieldsIndex) {
      m_emitSystemFields.push_back(emitSystemFieldsJsonList[emitSystemFieldsIndex].AsString());
    }
    m_emitSystemFieldsHasBeenSet = true;
  }
  return *this;
}

JsonValue SubscriptionFilter::Jsonize() const {
  JsonValue payload;

  if (m_filterNameHasBeenSet) {
    payload.WithString("filterName", m_filterName);
  }

  if (m_logGroupNameHasBeenSet) {
    payload.WithString("logGroupName", m_logGroupName);
  }

  if (m_filterPatternHasBeenSet) {
    payload.WithString("filterPattern", m_filterPattern);
  }

  if (m_destinationArnHasBeenSet) {
    payload.WithString("destinationArn", m_destinationArn);
  }

  if (m_roleArnHasBeenSet) {
    payload.WithString("roleArn", m_roleArn);
  }

  if (m_distributionHasBeenSet) {
    payload.WithString("distribution", DistributionMapper::GetNameForDistribution(m_distribution));
  }

  if (m_applyOnTransformedLogsHasBeenSet) {
    payload.WithBool("applyOnTransformedLogs", m_applyOnTransformedLogs);
  }

  if (m_creationTimeHasBeenSet) {
    payload.WithInt64("creationTime", m_creationTime);
  }

  if (m_fieldSelectionCriteriaHasBeenSet) {
    payload.WithString("fieldSelectionCriteria", m_fieldSelectionCriteria);
  }

  if (m_emitSystemFieldsHasBeenSet) {
    Aws::Utils::Array<JsonValue> emitSystemFieldsJsonList(m_emitSystemFields.size());
    for (unsigned emitSystemFieldsIndex = 0; emitSystemFieldsIndex < emitSystemFieldsJsonList.GetLength(); ++emitSystemFieldsIndex) {
      emitSystemFieldsJsonList[emitSystemFieldsIndex].AsString(m_emitSystemFields[emitSystemFieldsIndex]);
    }
    payload.WithArray("emitSystemFields", std::move(emitSystemFieldsJsonList));
  }

  return payload;
}

}  // namespace Model
}  // namespace CloudWatchLogs
}  // namespace Aws
