﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/m2/model/JobIdentifier.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace MainframeModernization {
namespace Model {

JobIdentifier::JobIdentifier(JsonView jsonValue) { *this = jsonValue; }

JobIdentifier& JobIdentifier::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("fileName")) {
    m_fileName = jsonValue.GetString("fileName");
    m_fileNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("scriptName")) {
    m_scriptName = jsonValue.GetString("scriptName");
    m_scriptNameHasBeenSet = true;
  }
  return *this;
}

JsonValue JobIdentifier::Jsonize() const {
  JsonValue payload;

  if (m_fileNameHasBeenSet) {
    payload.WithString("fileName", m_fileName);
  }

  if (m_scriptNameHasBeenSet) {
    payload.WithString("scriptName", m_scriptName);
  }

  return payload;
}

}  // namespace Model
}  // namespace MainframeModernization
}  // namespace Aws
