﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/outposts/model/ListAssetInstancesResult.h>

#include <utility>

using namespace Aws::Outposts::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListAssetInstancesResult::ListAssetInstancesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListAssetInstancesResult& ListAssetInstancesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("AssetInstances")) {
    Aws::Utils::Array<JsonView> assetInstancesJsonList = jsonValue.GetArray("AssetInstances");
    for (unsigned assetInstancesIndex = 0; assetInstancesIndex < assetInstancesJsonList.GetLength(); ++assetInstancesIndex) {
      m_assetInstances.push_back(assetInstancesJsonList[assetInstancesIndex].AsObject());
    }
    m_assetInstancesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
