﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/http/URI.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/outposts/model/ListCapacityTasksRequest.h>

#include <utility>

using namespace Aws::Outposts::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

Aws::String ListCapacityTasksRequest::SerializePayload() const { return {}; }

void ListCapacityTasksRequest::AddQueryStringParameters(URI& uri) const {
  Aws::StringStream ss;
  if (m_outpostIdentifierFilterHasBeenSet) {
    ss << m_outpostIdentifierFilter;
    uri.AddQueryStringParameter("OutpostIdentifierFilter", ss.str());
    ss.str("");
  }

  if (m_maxResultsHasBeenSet) {
    ss << m_maxResults;
    uri.AddQueryStringParameter("MaxResults", ss.str());
    ss.str("");
  }

  if (m_nextTokenHasBeenSet) {
    ss << m_nextToken;
    uri.AddQueryStringParameter("NextToken", ss.str());
    ss.str("");
  }

  if (m_capacityTaskStatusFilterHasBeenSet) {
    for (const auto& item : m_capacityTaskStatusFilter) {
      ss << CapacityTaskStatusMapper::GetNameForCapacityTaskStatus(item);
      uri.AddQueryStringParameter("CapacityTaskStatusFilter", ss.str());
      ss.str("");
    }
  }
}
