﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/partnercentral-selling/model/ListOpportunitiesResult.h>

#include <utility>

using namespace Aws::PartnerCentralSelling::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListOpportunitiesResult::ListOpportunitiesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListOpportunitiesResult& ListOpportunitiesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("OpportunitySummaries")) {
    Aws::Utils::Array<JsonView> opportunitySummariesJsonList = jsonValue.GetArray("OpportunitySummaries");
    for (unsigned opportunitySummariesIndex = 0; opportunitySummariesIndex < opportunitySummariesJsonList.GetLength();
         ++opportunitySummariesIndex) {
      m_opportunitySummaries.push_back(opportunitySummariesJsonList[opportunitySummariesIndex].AsObject());
    }
    m_opportunitySummariesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
