﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/pinpoint-sms-voice-v2/model/SetDefaultMessageFeedbackEnabledRequest.h>

#include <utility>

using namespace Aws::PinpointSMSVoiceV2::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String SetDefaultMessageFeedbackEnabledRequest::SerializePayload() const {
  JsonValue payload;

  if (m_configurationSetNameHasBeenSet) {
    payload.WithString("ConfigurationSetName", m_configurationSetName);
  }

  if (m_messageFeedbackEnabledHasBeenSet) {
    payload.WithBool("MessageFeedbackEnabled", m_messageFeedbackEnabled);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection SetDefaultMessageFeedbackEnabledRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "PinpointSMSVoiceV2.SetDefaultMessageFeedbackEnabled"));
  return headers;
}
