﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/core/utils/xml/XmlSerializer.h>
#include <aws/route53/model/CreateHostedZoneResult.h>

#include <utility>

using namespace Aws::Route53::Model;
using namespace Aws::Utils::Xml;
using namespace Aws::Utils;
using namespace Aws;

CreateHostedZoneResult::CreateHostedZoneResult(const Aws::AmazonWebServiceResult<XmlDocument>& result) { *this = result; }

CreateHostedZoneResult& CreateHostedZoneResult::operator=(const Aws::AmazonWebServiceResult<XmlDocument>& result) {
  const XmlDocument& xmlDocument = result.GetPayload();
  XmlNode resultNode = xmlDocument.GetRootElement();

  if (!resultNode.IsNull()) {
    XmlNode hostedZoneNode = resultNode.FirstChild("HostedZone");
    if (!hostedZoneNode.IsNull()) {
      m_hostedZone = hostedZoneNode;
      m_hostedZoneHasBeenSet = true;
    }
    XmlNode changeInfoNode = resultNode.FirstChild("ChangeInfo");
    if (!changeInfoNode.IsNull()) {
      m_changeInfo = changeInfoNode;
      m_changeInfoHasBeenSet = true;
    }
    XmlNode delegationSetNode = resultNode.FirstChild("DelegationSet");
    if (!delegationSetNode.IsNull()) {
      m_delegationSet = delegationSetNode;
      m_delegationSetHasBeenSet = true;
    }
    XmlNode vPCNode = resultNode.FirstChild("VPC");
    if (!vPCNode.IsNull()) {
      m_vPC = vPCNode;
      m_vPCHasBeenSet = true;
    }
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& locationIter = headers.find("location");
  if (locationIter != headers.end()) {
    m_location = locationIter->second;
    m_locationHasBeenSet = true;
  }

  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
