﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/core/utils/xml/XmlSerializer.h>
#include <aws/route53/model/CreateTrafficPolicyInstanceResult.h>

#include <utility>

using namespace Aws::Route53::Model;
using namespace Aws::Utils::Xml;
using namespace Aws::Utils;
using namespace Aws;

CreateTrafficPolicyInstanceResult::CreateTrafficPolicyInstanceResult(const Aws::AmazonWebServiceResult<XmlDocument>& result) {
  *this = result;
}

CreateTrafficPolicyInstanceResult& CreateTrafficPolicyInstanceResult::operator=(const Aws::AmazonWebServiceResult<XmlDocument>& result) {
  const XmlDocument& xmlDocument = result.GetPayload();
  XmlNode resultNode = xmlDocument.GetRootElement();

  if (!resultNode.IsNull()) {
    XmlNode trafficPolicyInstanceNode = resultNode.FirstChild("TrafficPolicyInstance");
    if (!trafficPolicyInstanceNode.IsNull()) {
      m_trafficPolicyInstance = trafficPolicyInstanceNode;
      m_trafficPolicyInstanceHasBeenSet = true;
    }
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& locationIter = headers.find("location");
  if (locationIter != headers.end()) {
    m_location = locationIter->second;
    m_locationHasBeenSet = true;
  }

  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
