﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/core/utils/xml/XmlSerializer.h>
#include <aws/route53/model/ListCidrLocationsResult.h>

#include <utility>

using namespace Aws::Route53::Model;
using namespace Aws::Utils::Xml;
using namespace Aws::Utils;
using namespace Aws;

ListCidrLocationsResult::ListCidrLocationsResult(const Aws::AmazonWebServiceResult<XmlDocument>& result) { *this = result; }

ListCidrLocationsResult& ListCidrLocationsResult::operator=(const Aws::AmazonWebServiceResult<XmlDocument>& result) {
  const XmlDocument& xmlDocument = result.GetPayload();
  XmlNode resultNode = xmlDocument.GetRootElement();

  if (!resultNode.IsNull()) {
    XmlNode nextTokenNode = resultNode.FirstChild("NextToken");
    if (!nextTokenNode.IsNull()) {
      m_nextToken = Aws::Utils::Xml::DecodeEscapedXmlText(nextTokenNode.GetText());
      m_nextTokenHasBeenSet = true;
    }
    XmlNode cidrLocationsNode = resultNode.FirstChild("CidrLocations");
    if (!cidrLocationsNode.IsNull()) {
      XmlNode cidrLocationsMember = cidrLocationsNode.FirstChild("member");
      m_cidrLocationsHasBeenSet = !cidrLocationsMember.IsNull();
      while (!cidrLocationsMember.IsNull()) {
        m_cidrLocations.push_back(cidrLocationsMember);
        cidrLocationsMember = cidrLocationsMember.NextNode("member");
      }

      m_cidrLocationsHasBeenSet = true;
    }
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
