﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/s3vectors/model/DataType.h>

using namespace Aws::Utils;

namespace Aws {
namespace S3Vectors {
namespace Model {
namespace DataTypeMapper {

static const int float32_HASH = HashingUtils::HashString("float32");

DataType GetDataTypeForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == float32_HASH) {
    return DataType::float32;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<DataType>(hashCode);
  }

  return DataType::NOT_SET;
}

Aws::String GetNameForDataType(DataType enumValue) {
  switch (enumValue) {
    case DataType::NOT_SET:
      return {};
    case DataType::float32:
      return "float32";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace DataTypeMapper
}  // namespace Model
}  // namespace S3Vectors
}  // namespace Aws
