﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/s3vectors/model/PutVectorBucketPolicyRequest.h>

#include <utility>

using namespace Aws::S3Vectors::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String PutVectorBucketPolicyRequest::SerializePayload() const {
  JsonValue payload;

  if (m_vectorBucketNameHasBeenSet) {
    payload.WithString("vectorBucketName", m_vectorBucketName);
  }

  if (m_vectorBucketArnHasBeenSet) {
    payload.WithString("vectorBucketArn", m_vectorBucketArn);
  }

  if (m_policyHasBeenSet) {
    payload.WithString("policy", m_policy);
  }

  return payload.View().WriteReadable();
}
