﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/sagemaker-runtime-http2/model/ModelError.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace SageMakerRuntimeHTTP2 {
namespace Model {

ModelError::ModelError(JsonView jsonValue) { *this = jsonValue; }

ModelError& ModelError::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Message")) {
    m_message = jsonValue.GetString("Message");
    m_messageHasBeenSet = true;
  }
  if (jsonValue.ValueExists("OriginalStatusCode")) {
    m_originalStatusCode = jsonValue.GetInteger("OriginalStatusCode");
    m_originalStatusCodeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("OriginalMessage")) {
    m_originalMessage = jsonValue.GetString("OriginalMessage");
    m_originalMessageHasBeenSet = true;
  }
  if (jsonValue.ValueExists("LogStreamArn")) {
    m_logStreamArn = jsonValue.GetString("LogStreamArn");
    m_logStreamArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ErrorCode")) {
    m_errorCode = jsonValue.GetString("ErrorCode");
    m_errorCodeHasBeenSet = true;
  }
  return *this;
}

JsonValue ModelError::Jsonize() const {
  JsonValue payload;

  if (m_messageHasBeenSet) {
    payload.WithString("Message", m_message);
  }

  if (m_originalStatusCodeHasBeenSet) {
    payload.WithInteger("OriginalStatusCode", m_originalStatusCode);
  }

  if (m_originalMessageHasBeenSet) {
    payload.WithString("OriginalMessage", m_originalMessage);
  }

  if (m_logStreamArnHasBeenSet) {
    payload.WithString("LogStreamArn", m_logStreamArn);
  }

  if (m_errorCodeHasBeenSet) {
    payload.WithString("ErrorCode", m_errorCode);
  }

  return payload;
}

}  // namespace Model
}  // namespace SageMakerRuntimeHTTP2
}  // namespace Aws
