﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/eks/model/DescribeIdentityProviderConfigRequest.h>

#include <utility>

using namespace Aws::EKS::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DescribeIdentityProviderConfigRequest::SerializePayload() const {
  JsonValue payload;

  if (m_identityProviderConfigHasBeenSet) {
    payload.WithObject("identityProviderConfig", m_identityProviderConfig.Jsonize());
  }

  return payload.View().WriteReadable();
}
