﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/finspace/model/CreateKxDataviewRequest.h>

#include <utility>

using namespace Aws::finspace::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateKxDataviewRequest::SerializePayload() const {
  JsonValue payload;

  if (m_dataviewNameHasBeenSet) {
    payload.WithString("dataviewName", m_dataviewName);
  }

  if (m_azModeHasBeenSet) {
    payload.WithString("azMode", KxAzModeMapper::GetNameForKxAzMode(m_azMode));
  }

  if (m_availabilityZoneIdHasBeenSet) {
    payload.WithString("availabilityZoneId", m_availabilityZoneId);
  }

  if (m_changesetIdHasBeenSet) {
    payload.WithString("changesetId", m_changesetId);
  }

  if (m_segmentConfigurationsHasBeenSet) {
    Aws::Utils::Array<JsonValue> segmentConfigurationsJsonList(m_segmentConfigurations.size());
    for (unsigned segmentConfigurationsIndex = 0; segmentConfigurationsIndex < segmentConfigurationsJsonList.GetLength();
         ++segmentConfigurationsIndex) {
      segmentConfigurationsJsonList[segmentConfigurationsIndex].AsObject(m_segmentConfigurations[segmentConfigurationsIndex].Jsonize());
    }
    payload.WithArray("segmentConfigurations", std::move(segmentConfigurationsJsonList));
  }

  if (m_autoUpdateHasBeenSet) {
    payload.WithBool("autoUpdate", m_autoUpdate);
  }

  if (m_readWriteHasBeenSet) {
    payload.WithBool("readWrite", m_readWrite);
  }

  if (m_descriptionHasBeenSet) {
    payload.WithString("description", m_description);
  }

  if (m_tagsHasBeenSet) {
    JsonValue tagsJsonMap;
    for (auto& tagsItem : m_tags) {
      tagsJsonMap.WithString(tagsItem.first, tagsItem.second);
    }
    payload.WithObject("tags", std::move(tagsJsonMap));
  }

  if (m_clientTokenHasBeenSet) {
    payload.WithString("clientToken", m_clientToken);
  }

  return payload.View().WriteReadable();
}
