﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/logs/model/DeleteAccountPolicyRequest.h>

#include <utility>

using namespace Aws::CloudWatchLogs::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DeleteAccountPolicyRequest::SerializePayload() const {
  JsonValue payload;

  if (m_policyNameHasBeenSet) {
    payload.WithString("policyName", m_policyName);
  }

  if (m_policyTypeHasBeenSet) {
    payload.WithString("policyType", PolicyTypeMapper::GetNameForPolicyType(m_policyType));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeleteAccountPolicyRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "Logs_20140328.DeleteAccountPolicy"));
  return headers;
}
