﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/logs/model/DescribeQueryDefinitionsResult.h>

#include <utility>

using namespace Aws::CloudWatchLogs::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

DescribeQueryDefinitionsResult::DescribeQueryDefinitionsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

DescribeQueryDefinitionsResult& DescribeQueryDefinitionsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("queryDefinitions")) {
    Aws::Utils::Array<JsonView> queryDefinitionsJsonList = jsonValue.GetArray("queryDefinitions");
    for (unsigned queryDefinitionsIndex = 0; queryDefinitionsIndex < queryDefinitionsJsonList.GetLength(); ++queryDefinitionsIndex) {
      m_queryDefinitions.push_back(queryDefinitionsJsonList[queryDefinitionsIndex].AsObject());
    }
    m_queryDefinitionsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
