﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/logs/model/Entity.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace CloudWatchLogs {
namespace Model {

Entity::Entity(JsonView jsonValue) { *this = jsonValue; }

Entity& Entity::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("keyAttributes")) {
    Aws::Map<Aws::String, JsonView> keyAttributesJsonMap = jsonValue.GetObject("keyAttributes").GetAllObjects();
    for (auto& keyAttributesItem : keyAttributesJsonMap) {
      m_keyAttributes[keyAttributesItem.first] = keyAttributesItem.second.AsString();
    }
    m_keyAttributesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("attributes")) {
    Aws::Map<Aws::String, JsonView> attributesJsonMap = jsonValue.GetObject("attributes").GetAllObjects();
    for (auto& attributesItem : attributesJsonMap) {
      m_attributes[attributesItem.first] = attributesItem.second.AsString();
    }
    m_attributesHasBeenSet = true;
  }
  return *this;
}

JsonValue Entity::Jsonize() const {
  JsonValue payload;

  if (m_keyAttributesHasBeenSet) {
    JsonValue keyAttributesJsonMap;
    for (auto& keyAttributesItem : m_keyAttributes) {
      keyAttributesJsonMap.WithString(keyAttributesItem.first, keyAttributesItem.second);
    }
    payload.WithObject("keyAttributes", std::move(keyAttributesJsonMap));
  }

  if (m_attributesHasBeenSet) {
    JsonValue attributesJsonMap;
    for (auto& attributesItem : m_attributes) {
      attributesJsonMap.WithString(attributesItem.first, attributesItem.second);
    }
    payload.WithObject("attributes", std::move(attributesJsonMap));
  }

  return payload;
}

}  // namespace Model
}  // namespace CloudWatchLogs
}  // namespace Aws
