﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/opensearchserverless/model/EncryptionConfig.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace OpenSearchServerless {
namespace Model {

EncryptionConfig::EncryptionConfig(JsonView jsonValue) { *this = jsonValue; }

EncryptionConfig& EncryptionConfig::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("aWSOwnedKey")) {
    m_aWSOwnedKey = jsonValue.GetBool("aWSOwnedKey");
    m_aWSOwnedKeyHasBeenSet = true;
  }
  if (jsonValue.ValueExists("kmsKeyArn")) {
    m_kmsKeyArn = jsonValue.GetString("kmsKeyArn");
    m_kmsKeyArnHasBeenSet = true;
  }
  return *this;
}

JsonValue EncryptionConfig::Jsonize() const {
  JsonValue payload;

  if (m_aWSOwnedKeyHasBeenSet) {
    payload.WithBool("aWSOwnedKey", m_aWSOwnedKey);
  }

  if (m_kmsKeyArnHasBeenSet) {
    payload.WithString("kmsKeyArn", m_kmsKeyArn);
  }

  return payload;
}

}  // namespace Model
}  // namespace OpenSearchServerless
}  // namespace Aws
