﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/pinpoint-sms-voice-v2/model/DeletePoolRequest.h>

#include <utility>

using namespace Aws::PinpointSMSVoiceV2::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DeletePoolRequest::SerializePayload() const {
  JsonValue payload;

  if (m_poolIdHasBeenSet) {
    payload.WithString("PoolId", m_poolId);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeletePoolRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "PinpointSMSVoiceV2.DeletePool"));
  return headers;
}
