﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/s3vectors/model/EncryptionConfiguration.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace S3Vectors {
namespace Model {

EncryptionConfiguration::EncryptionConfiguration(JsonView jsonValue) { *this = jsonValue; }

EncryptionConfiguration& EncryptionConfiguration::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("sseType")) {
    m_sseType = SseTypeMapper::GetSseTypeForName(jsonValue.GetString("sseType"));
    m_sseTypeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("kmsKeyArn")) {
    m_kmsKeyArn = jsonValue.GetString("kmsKeyArn");
    m_kmsKeyArnHasBeenSet = true;
  }
  return *this;
}

JsonValue EncryptionConfiguration::Jsonize() const {
  JsonValue payload;

  if (m_sseTypeHasBeenSet) {
    payload.WithString("sseType", SseTypeMapper::GetNameForSseType(m_sseType));
  }

  if (m_kmsKeyArnHasBeenSet) {
    payload.WithString("kmsKeyArn", m_kmsKeyArn);
  }

  return payload;
}

}  // namespace Model
}  // namespace S3Vectors
}  // namespace Aws
