﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/s3vectors/model/IndexSummary.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace S3Vectors {
namespace Model {

IndexSummary::IndexSummary(JsonView jsonValue) { *this = jsonValue; }

IndexSummary& IndexSummary::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("vectorBucketName")) {
    m_vectorBucketName = jsonValue.GetString("vectorBucketName");
    m_vectorBucketNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("indexName")) {
    m_indexName = jsonValue.GetString("indexName");
    m_indexNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("indexArn")) {
    m_indexArn = jsonValue.GetString("indexArn");
    m_indexArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("creationTime")) {
    m_creationTime = jsonValue.GetDouble("creationTime");
    m_creationTimeHasBeenSet = true;
  }
  return *this;
}

JsonValue IndexSummary::Jsonize() const {
  JsonValue payload;

  if (m_vectorBucketNameHasBeenSet) {
    payload.WithString("vectorBucketName", m_vectorBucketName);
  }

  if (m_indexNameHasBeenSet) {
    payload.WithString("indexName", m_indexName);
  }

  if (m_indexArnHasBeenSet) {
    payload.WithString("indexArn", m_indexArn);
  }

  if (m_creationTimeHasBeenSet) {
    payload.WithDouble("creationTime", m_creationTime.SecondsWithMSPrecision());
  }

  return payload;
}

}  // namespace Model
}  // namespace S3Vectors
}  // namespace Aws
