﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/s3vectors/model/ListVectorBucketsResult.h>

#include <utility>

using namespace Aws::S3Vectors::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListVectorBucketsResult::ListVectorBucketsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListVectorBucketsResult& ListVectorBucketsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }
  if (jsonValue.ValueExists("vectorBuckets")) {
    Aws::Utils::Array<JsonView> vectorBucketsJsonList = jsonValue.GetArray("vectorBuckets");
    for (unsigned vectorBucketsIndex = 0; vectorBucketsIndex < vectorBucketsJsonList.GetLength(); ++vectorBucketsIndex) {
      m_vectorBuckets.push_back(vectorBucketsJsonList[vectorBucketsIndex].AsObject());
    }
    m_vectorBucketsHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
