﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/controltower/model/DriftStatusSummary.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace ControlTower {
namespace Model {

DriftStatusSummary::DriftStatusSummary(JsonView jsonValue) { *this = jsonValue; }

DriftStatusSummary& DriftStatusSummary::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("driftStatus")) {
    m_driftStatus = DriftStatusMapper::GetDriftStatusForName(jsonValue.GetString("driftStatus"));
    m_driftStatusHasBeenSet = true;
  }
  if (jsonValue.ValueExists("types")) {
    m_types = jsonValue.GetObject("types");
    m_typesHasBeenSet = true;
  }
  return *this;
}

JsonValue DriftStatusSummary::Jsonize() const {
  JsonValue payload;

  if (m_driftStatusHasBeenSet) {
    payload.WithString("driftStatus", DriftStatusMapper::GetNameForDriftStatus(m_driftStatus));
  }

  if (m_typesHasBeenSet) {
    payload.WithObject("types", m_types.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace ControlTower
}  // namespace Aws
