﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/deadline/model/BudgetStatus.h>

using namespace Aws::Utils;

namespace Aws {
namespace deadline {
namespace Model {
namespace BudgetStatusMapper {

static const int ACTIVE_HASH = HashingUtils::HashString("ACTIVE");
static const int INACTIVE_HASH = HashingUtils::HashString("INACTIVE");

BudgetStatus GetBudgetStatusForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == ACTIVE_HASH) {
    return BudgetStatus::ACTIVE;
  } else if (hashCode == INACTIVE_HASH) {
    return BudgetStatus::INACTIVE;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<BudgetStatus>(hashCode);
  }

  return BudgetStatus::NOT_SET;
}

Aws::String GetNameForBudgetStatus(BudgetStatus enumValue) {
  switch (enumValue) {
    case BudgetStatus::NOT_SET:
      return {};
    case BudgetStatus::ACTIVE:
      return "ACTIVE";
    case BudgetStatus::INACTIVE:
      return "INACTIVE";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace BudgetStatusMapper
}  // namespace Model
}  // namespace deadline
}  // namespace Aws
